# Intuition
<!-- Describe your first thoughts on how to solve this problem. -->
This can be solved by a set which stores its elements on accessibility order.

# Concept

LinkedHashSet is used when we want to store elements on their accessibility order, with recent accessed element on first position and earliest accessed element on last position. 

( Read the first paragraph of LinkedHashSet in Oracle documentation for it's implementation if you're more curious. )

# Approach
<!-- Describe your approach to solving the problem. -->
Created a class to store the key-value pairs (named cell), created functions as per stated in the question

Keep in mind that :
- During get :  If the key is present already and we have accessed it's value , then it will become the most recently accessed(used) key-value pair. So it should be maintained in the LinkedHashSet that this pair is the most recently used.
- During put : even the key was already present, but as we updated(accessed) it, it would be now most recently accessed pair 

Have a look at the code , still have any confusion then please let me know in the comments
Keep Solving.:)

# Complexity
- Time complexity : $$O(1)$$
<!-- Add your time complexity here, e.g. $$O(n)$$ -->

- Space complexity : $$O( capacity )$$
<!-- Add your space complexity here, e.g. $$O(n)$$ -->

# Code
```
class cell{                // created a class to store the key-value pairs
    int key;
    int value;
    public cell( int k, int val){
        this.key = k;
        this.value = val;
    }
}

class LRUCache {

    int cap;
    Set<cell> cache = new LinkedHashSet<>();     // A set implemented with LinkedHashSet was used to store elements in order of use
    HashMap<Integer, cell> h = new HashMap<>();  // hashmap to check if that key-value pair is already present
    public LRUCache(int capacity) {
        this.cap = capacity;
    }
    
    public int get(int key) {
        if( !h.containsKey(key)){   // if that key isn't present then simply return (-1)
            return -1;
        }
                           // Now , as the key is present already and we have accessed it's value , then it will become the most recently accessed(used) key-value pair. So it should be maintained in the LinkedHashSet that this pair is the most recently used, in order to do this , previous version was removed and the key-value will be again inserted so that it remains ahead of other pairs.
        cell cur = h.get(key);
        cache.remove(cur);
        cache.add(cur);
        return cur.value;
    }
    
    public void put(int key, int value) {

        if( h.containsKey(key)){      // if key already present then update it's previous value
            h.get(key).value = value;
            get(key);                 // even the key was already present, but as we updated(accessed) it, it would be now most recently accessed pair ; so calling get function to update the cache set
            return;
        }
        if( cache.size() == cap){    // if lru capacity has already reached then remove that pair which was accessed(used) earliest , i mean the pair which will be in last of the LinkedHashSet
            cell lastAccessedCell = cache.iterator().next();
            h.remove(lastAccessedCell.key);
            cache.remove(lastAccessedCell);
        }
        
        cell c = new cell( key, value);
        h.put(key, c);
        cache.add( c);
    }
}

/**
 * Your LRUCache object will be instantiated and called as such:
 * LRUCache obj = new LRUCache(capacity);
 * int param_1 = obj.get(key);
 * obj.put(key,value);
 */
```